<?php if (!isset($pageTitle)) $pageTitle = 'Dashboard'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?> - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="wrapper">
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <h3>🏪 <?php echo SHOP_NAME; ?></h3>
            </div>
            <nav>
                <ul class="sidebar-menu">
                    <li><a href="index.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">
                        📊 Dashboard
                    </a></li>
                    <li><a href="pos.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'pos.php' ? 'active' : ''; ?>">
                        💰 POS
                    </a></li>
                    <li><a href="products.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'products.php' ? 'active' : ''; ?>">
                        📦 Products
                    </a></li>
                    <li><a href="customers.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'customers.php' ? 'active' : ''; ?>">
                        👥 Customers
                    </a></li>
                    <li><a href="sales.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'sales.php' ? 'active' : ''; ?>">
                        🛒 Sales
                    </a></li>
                    <li><a href="reports.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'reports.php' ? 'active' : ''; ?>">
                        📈 Reports
                    </a></li>
                    <li><a href="logout.php">
                        🚪 Logout
                    </a></li>
                </ul>
            </nav>
        </aside>

        <main class="main-content">
            <header class="topbar">
                <div class="topbar-left">
                    <button class="menu-toggle" id="menuToggle">☰</button>
                    <h2><?php echo htmlspecialchars($pageTitle); ?></h2>
                </div>
                <div class="topbar-right">
                    <div class="user-info">
                        <strong><?php echo htmlspecialchars(getUsername()); ?></strong>
                        <span>(<?php echo htmlspecialchars(getUserRole()); ?>)</span>
                    </div>
                </div>
            </header>
            
            <div class="content-wrapper">
